/*
 * Copyright (c) 2016, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */
/**
 * \file    uart.h
 *
 * \brief   uart Header File
 *
 * This header file contains the Macros definitions and Function declarations 
 * for uart test application
 *
 * \author  0043
 *
 * \version 01a,25aug,2010 Created.
 */
/*========================
 * Includes
 *========================
 */
 
#include "DM388_types.h"
//#include "DM388_EVM.h"
//#include "DM388_uart.h"
#include "DM388_uart.h"

/* ------------------------------------------------------------------------ *
 *  UART Handle                                                             *
 * ------------------------------------------------------------------------ */
typedef UINT32 UART_Handle;

/* ------------------------------------------------------------------------ *
 *  UART IDs                                                                *
 * ------------------------------------------------------------------------ */
#define UART_0                  ( 0 )
#define UART_1                  ( 1 )
#define UART_2                  ( 2 )


//#define GPIO1_BASE			0x4804C000u

//#define GPIO1_SYSCONFIG		*(volatile UINT32 *)(GPIO1_BASE + 0x010)
//#define GPIO1_OE			*(volatile UINT32 *)(GPIO1_BASE + 0x134)
//#define GPIO1_DATAOUT		*(volatile UINT32 *)(GPIO1_BASE + 0x13C)

//#define GP1_8				(1 << 8)


/* ------------------------------------------------------------------------ *
 *  Prototypes                                                              *
 * ------------------------------------------------------------------------ */
UART_Handle _UART_open( UINT16 id, UINT32 baudrate );
INT16       _UART_close( UART_Handle uart );

INT16 _UART_xmtReady( UART_Handle uart );
INT16 _UART_rcvReady( UART_Handle uart );

INT16 _UART_putChar( UART_Handle uart, UINT8 data );
INT16 _UART_getChar( UART_Handle uart, UINT8* data );

UINT32 _UART_rget( UART_Handle uart, UINT32 reg );
void   _UART_rset( UART_Handle uart, UINT32 reg, UINT32 reg_value );
INT16 uart_send( UART_Handle uart, UINT8 tx, INT32 timeout );
INT16 uart_recv( UART_Handle uart, UINT8* rx, INT32 timeout );
INT16 UART_EnableHWFlowCntl (UART_Handle uart);







